/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.model.animation;

import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.data.IAnimationFrame;
import noppes.npcs.api.entity.data.IAnimationPart;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.util.IModelRenderer;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.client.model.ModelNpcAlt;
import noppes.npcs.client.model.animation.AnimationDamageHitbox;
import noppes.npcs.client.model.animation.PartConfig;
import noppes.npcs.constants.EnumParts;

public class AnimationFrameConfig
implements IAnimationFrame {
    public static final AnimationFrameConfig EMPTY = new AnimationFrameConfig();
    public boolean smooth = false;
    public boolean isNowDamage = false;
    public boolean showMainHand = true;
    public boolean showOffHand = true;
    public boolean showHelmet = true;
    public boolean showBody = true;
    public boolean showLegs = true;
    public boolean showFeets = true;
    public int speed = 10;
    public int delay = 0;
    public int id = -1;
    public final float[] motions = new float[]{0.0f, 0.0f, 0.0f};
    private int holdRightType = 0;
    private int holdLeftType = 0;
    private IItemStack holdRightStack = ItemStackWrapper.AIR;
    private IItemStack holdLeftStack = ItemStackWrapper.AIR;
    public int damageDelay = 0;
    public final Map<Integer, AnimationDamageHitbox> damageHitboxes = new TreeMap<Integer, AnimationDamageHitbox>();
    public final Map<Integer, PartConfig> parts = new TreeMap<Integer, PartConfig>();
    public ResourceLocation sound = null;
    public int emotionId = -1;

    public AnimationFrameConfig(int id) {
        this();
        this.id = id;
    }

    public AnimationFrameConfig() {
        for (int i = 0; i < 8; ++i) {
            PartConfig pc = new PartConfig(i, AnimationFrameConfig.getPartType(i));
            this.parts.put(i, pc);
        }
        this.clear();
    }

    public void clear() {
        this.smooth = false;
        this.speed = 10;
        this.delay = 0;
        this.motions[0] = 0.0f;
        this.motions[1] = 0.0f;
        this.motions[2] = 0.0f;
        this.damageHitboxes.clear();
        this.damageHitboxes.put(0, new AnimationDamageHitbox(0));
    }

    public AnimationFrameConfig copy() {
        AnimationFrameConfig newAfc = new AnimationFrameConfig();
        newAfc.load(this.writeNBT());
        return newAfc;
    }

    private void fixParts() {
        int i = 0;
        TreeMap<Integer, PartConfig> newParts = new TreeMap<Integer, PartConfig>();
        boolean change = false;
        for (Integer id : this.parts.keySet()) {
            PartConfig ps = this.parts.get(id);
            if (id != i || ps.id != i) {
                change = true;
            }
            ps.id = i;
            newParts.put(i, ps);
            ++i;
        }
        if (change) {
            this.parts.clear();
            this.parts.putAll(newParts);
            for (int p = 0; p < 8; ++p) {
                if (this.parts.containsKey(p)) continue;
                this.parts.put(p, new PartConfig(p, AnimationFrameConfig.getPartType(p)));
            }
        }
    }

    @Override
    public int getEndDelay() {
        if (this.delay < 0) {
            this.delay *= -1;
        }
        if (this.delay > 1200) {
            this.delay = -1200;
        }
        return this.delay;
    }

    @Override
    public IAnimationPart getPart(int id) {
        if (id < 0) {
            id *= -1;
        }
        if (id > this.parts.size()) {
            id %= this.parts.size();
        }
        return this.parts.get(id);
    }

    @Override
    public int getSpeed() {
        if (this.speed < 0) {
            this.speed *= -1;
        }
        if (this.speed == 0) {
            this.speed = 1;
        } else if (this.speed > 1200) {
            this.speed = 1200;
        }
        return this.speed;
    }

    @Override
    public boolean isSmooth() {
        return this.smooth;
    }

    public void load(NBTTagCompound compound) {
        int i;
        this.id = compound.func_74762_e("ID");
        this.setSmooth(compound.func_74767_n("IsSmooth"));
        this.setSpeed(compound.func_74762_e("Speed"));
        this.setEndDelay(compound.func_74762_e("EndDelay"));
        if (compound.func_150297_b("StartSound", 8)) {
            this.setStartSound(compound.func_74779_i("StartSound"));
        }
        if (compound.func_150297_b("EmotionID", 3)) {
            this.setStartEmotion(compound.func_74762_e("EmotionID"));
        }
        if (compound.func_150297_b("IsNowDamage", 1)) {
            this.isNowDamage = compound.func_74767_n("IsNowDamage");
        }
        if (compound.func_150297_b("ShowStacks", 7)) {
            byte[] array = compound.func_74770_j("ShowStacks");
            this.showMainHand = array.length == 0 || array[0] != 0;
            this.showOffHand = array.length < 1 || array[1] != 0;
            this.showHelmet = array.length < 2 || array[2] != 0;
            this.showBody = array.length < 3 || array[3] != 0;
            this.showLegs = array.length < 4 || array[4] != 0;
            this.showFeets = array.length < 5 || array[5] != 0;
        }
        this.setHoldRightStackType(compound.func_74762_e("HoldRightType"));
        this.setHoldLeftStackType(compound.func_74762_e("HoldLeftType"));
        NpcAPI api = NpcAPI.Instance();
        if (compound.func_150297_b("HoldRightStack", 10)) {
            assert (api != null);
            this.setHoldRightStack(api.getIItemStack(new ItemStack(compound.func_74775_l("HoldRightStack"))));
        }
        if (compound.func_150297_b("HoldLeftStack", 10)) {
            assert (api != null);
            this.setHoldLeftStack(api.getIItemStack(new ItemStack(compound.func_74775_l("HoldLeftStack"))));
        }
        this.parts.clear();
        for (i = 0; i < compound.func_150295_c("PartConfigs", 10).func_74745_c(); ++i) {
            NBTTagCompound nbt = compound.func_150295_c("PartConfigs", 10).func_150305_b(i);
            PartConfig pc = nbt.func_150297_b("Part", 3) && this.parts.containsKey(nbt.func_74762_e("Part")) ? this.parts.get(nbt.func_74762_e("Part")) : new PartConfig(i, AnimationFrameConfig.getPartType(i));
            pc.load(nbt);
            if (pc.type == EnumParts.WRIST_RIGHT || pc.type == EnumParts.WRIST_LEFT || pc.type == EnumParts.FOOT_RIGHT || pc.type == EnumParts.FOOT_LEFT) continue;
            this.parts.put(pc.id, pc);
        }
        for (int p = 0; p < 8; ++p) {
            if (this.parts.containsKey(p)) continue;
            this.parts.put(p, new PartConfig(p, AnimationFrameConfig.getPartType(p)));
        }
        if (compound.func_150297_b("Motion", 9) && ((NBTTagList)compound.func_74781_a("Motion")).func_150303_d() == 5) {
            for (i = 0; i < 3 && i < compound.func_150295_c("Motion", 5).func_74745_c(); ++i) {
                this.motions[i] = compound.func_150295_c("Motion", 5).func_150308_e(i);
            }
        }
        this.damageHitboxes.clear();
        NBTTagList list = compound.func_150295_c("DamageHitboxes", 10);
        for (int i2 = 0; i2 < list.func_74745_c(); ++i2) {
            this.damageHitboxes.put(i2, new AnimationDamageHitbox(list.func_150305_b(i2), i2));
        }
        if (this.damageHitboxes.isEmpty()) {
            this.damageHitboxes.put(0, new AnimationDamageHitbox(0));
        }
        this.fixParts();
    }

    public static EnumParts getPartType(int id) {
        switch (id) {
            case 0: {
                return EnumParts.HEAD;
            }
            case 1: {
                return EnumParts.ARM_LEFT;
            }
            case 2: {
                return EnumParts.ARM_RIGHT;
            }
            case 3: {
                return EnumParts.BODY;
            }
            case 4: {
                return EnumParts.LEG_LEFT;
            }
            case 5: {
                return EnumParts.LEG_RIGHT;
            }
            case 6: {
                return EnumParts.LEFT_STACK;
            }
            case 7: {
                return EnumParts.RIGHT_STACK;
            }
        }
        return EnumParts.CUSTOM;
    }

    public void removePart(PartConfig part) {
        if (part == null || this.parts.size() <= 8) {
            return;
        }
        for (Integer id : this.parts.keySet()) {
            PartConfig p = this.parts.get(id);
            if (!p.equals(part) && p.id != part.id) continue;
            this.parts.remove(id);
            this.fixParts();
            return;
        }
    }

    @Override
    public void setEndDelay(int ticks) {
        if (ticks < 0) {
            ticks *= -1;
        }
        if (ticks > 1200) {
            ticks = 1200;
        }
        this.delay = ticks;
    }

    @Override
    public void setSmooth(boolean isSmooth) {
        this.smooth = isSmooth;
    }

    @Override
    public void setSpeed(int ticks) {
        if (ticks < 0) {
            ticks *= -1;
        }
        if (ticks == 0) {
            ticks = 1;
        } else if (ticks > 1200) {
            ticks = 1200;
        }
        this.speed = ticks;
    }

    public NBTTagCompound writeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("IsSmooth", this.smooth);
        compound.func_74757_a("IsNowDamage", this.isNowDamage);
        compound.func_74768_a("ID", this.id);
        compound.func_74768_a("Speed", this.speed);
        compound.func_74768_a("EndDelay", this.delay);
        NBTTagList list = new NBTTagList();
        for (int id : this.parts.keySet()) {
            list.func_74742_a((NBTBase)this.parts.get(id).save());
        }
        compound.func_74782_a("PartConfigs", (NBTBase)list);
        NBTTagList listM = new NBTTagList();
        for (int i = 0; i < 3; ++i) {
            listM.func_74742_a((NBTBase)new NBTTagFloat(this.motions[i]));
        }
        compound.func_74782_a("Motion", (NBTBase)listM);
        compound.func_74778_a("StartSound", this.getStartSound());
        compound.func_74768_a("EmotionID", this.emotionId);
        compound.func_74768_a("Version", 1);
        compound.func_74768_a("HoldRightType", this.holdRightType);
        compound.func_74768_a("HoldLeftType", this.holdLeftType);
        compound.func_74782_a("HoldRightStack", (NBTBase)this.holdRightStack.getMCItemStack().func_77955_b(new NBTTagCompound()));
        compound.func_74782_a("HoldLeftStack", (NBTBase)this.holdLeftStack.getMCItemStack().func_77955_b(new NBTTagCompound()));
        compound.func_74773_a("ShowStacks", new byte[]{(byte)(this.showMainHand ? 1 : 0), (byte)(this.showOffHand ? 1 : 0), (byte)(this.showHelmet ? 1 : 0), (byte)(this.showBody ? 1 : 0), (byte)(this.showLegs ? 1 : 0), (byte)(this.showFeets ? 1 : 0)});
        NBTTagList listDHB = new NBTTagList();
        int i = 0;
        for (AnimationDamageHitbox aDHB : this.damageHitboxes.values()) {
            aDHB.id = i++;
            listDHB.func_74742_a((NBTBase)aDHB.getNBT());
        }
        compound.func_74782_a("DamageHitboxes", (NBTBase)listDHB);
        return compound;
    }

    @Override
    public String getStartSound() {
        return this.sound == null ? "" : this.sound.toString();
    }

    @Override
    public void setStartSound(String sound) {
        if (sound == null || sound.isEmpty()) {
            this.sound = null;
        }
        if (sound != null) {
            this.sound = new ResourceLocation(sound);
            if (this.sound.func_110623_a().isEmpty() || this.sound.func_110624_b().isEmpty()) {
                this.sound = null;
            }
        }
    }

    public void setStartSound(ResourceLocation resource) {
        this.sound = resource;
    }

    @Override
    public int getStartEmotion() {
        return this.emotionId;
    }

    @Override
    public void setStartEmotion(int id) {
        this.emotionId = id;
    }

    public void setRotationAngles(ModelNpcAlt model) {
        for (int partId : this.parts.keySet()) {
            IModelRenderer biped = model.getPart(partId);
            if (biped == null) continue;
            PartConfig part = this.parts.get(partId);
            part.show = biped.isShowModel();
            float[] rotations = biped.getRotations();
            float[] offsets = biped.getOffsets();
            float[] scales = biped.getScales();
            for (int i = 0; i < 5; ++i) {
                part.rotation[i] = rotations[i];
                if (i > 2) continue;
                part.offset[i] = offsets[i];
                part.scale[i] = scales[i];
            }
        }
    }

    @Override
    public boolean isNowDamage() {
        return this.isNowDamage;
    }

    @Override
    public int getHoldRightStackType() {
        return this.holdRightType;
    }

    @Override
    public int getHoldLeftStackType() {
        return this.holdLeftType;
    }

    @Override
    public IItemStack getHoldRightStack() {
        return this.holdRightStack;
    }

    @Override
    public IItemStack getHoldLeftStack() {
        return this.holdLeftStack;
    }

    @Override
    public void setHoldRightStackType(int type) {
        if (type < 0) {
            type *= -1;
        }
        this.holdRightType = type % 8;
    }

    @Override
    public void setHoldLeftStackType(int type) {
        if (type < 0) {
            type *= -1;
        }
        this.holdLeftType = type % 8;
    }

    @Override
    public void setHoldRightStack(IItemStack stack) {
        if (stack == null) {
            stack = ItemStackWrapper.AIR;
        }
        this.holdRightStack = stack;
    }

    @Override
    public void setHoldLeftStack(IItemStack stack) {
        if (stack == null) {
            stack = ItemStackWrapper.AIR;
        }
        this.holdLeftStack = stack;
    }

    public void setHoldRightStack(ItemStack stack) {
        if (stack == null) {
            stack = ItemStack.field_190927_a;
        }
        this.holdRightStack = Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(stack);
    }

    public void setHoldLeftStack(ItemStack stack) {
        if (stack == null) {
            stack = ItemStack.field_190927_a;
        }
        this.holdLeftStack = Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(stack);
    }

    public void resetFrom(Map<Integer, Float[]> rotationAngles, @Nonnull AnimationFrameConfig currentFrame) {
        this.smooth = currentFrame.smooth;
        this.showMainHand = currentFrame.showMainHand;
        this.showOffHand = currentFrame.showOffHand;
        this.showHelmet = currentFrame.showHelmet;
        this.showBody = currentFrame.showBody;
        this.showLegs = currentFrame.showLegs;
        this.showFeets = currentFrame.showFeets;
        this.holdRightType = currentFrame.holdRightType;
        this.holdLeftType = currentFrame.holdLeftType;
        this.holdRightStack = currentFrame.holdRightStack;
        this.holdLeftStack = currentFrame.holdLeftStack;
        this.parts.clear();
        for (Integer i : rotationAngles.keySet()) {
            PartConfig pc = new PartConfig(i, AnimationFrameConfig.getPartType(i));
            if (currentFrame.parts.containsKey(i)) {
                pc.show = currentFrame.parts.get((Object)i).show;
                pc.disable = currentFrame.parts.get((Object)i).disable;
            }
            pc.set(rotationAngles.get(i));
            this.parts.put(i, pc);
        }
    }

    static {
        for (PartConfig p : AnimationFrameConfig.EMPTY.parts.values()) {
            p.disable = true;
        }
    }
}

